// EditTimeZone.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "EditTimeZone.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditTimeZone dialog


CEditTimeZone::CEditTimeZone(CWnd* pParent /*=NULL*/)
	: CDialog(CEditTimeZone::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditTimeZone)
	m_TZDescription = _T("");
	m_TZName = _T("");
	//}}AFX_DATA_INIT
}

CEditTimeZone ::CEditTimeZone(IApplication *pApp):CDialog(CEditTimeZone::IDD, NULL)
{
	pApplication = pApp;
	pTZ.CreateInstance(__uuidof(TimeZone));
	
}
void CEditTimeZone::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditTimeZone)
	DDX_Control(pDX, IDC_EDITTZ_DESC, m_Cnt_TZDescription);
	DDX_Control(pDX, IDC_EDITTZ_NAME, m_Cnt_TZName);
	DDX_Control(pDX, IDC_TZLIST, m_TZList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Text(pDX, IDC_EDITTZ_DESC, m_TZDescription);
	DDX_Text(pDX, IDC_EDITTZ_NAME, m_TZName);
	//}}AFX_DATA_MAP
}
void CEditTimeZone :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				m_AcctList.AddString(pAccount->AccountName);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}
void CEditTimeZone ::LoadTimeZones()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		_variant_t vTZs;
		vTZs.Clear();
		pApplication->GetTimeZonesByAccountName(bstrAcctName,&vTZs); // get timezone details of particular account  in WP-CS database server
		
		if(vTZs.vt ==  VT_EMPTY)
		{
			return; 
		}
		
		long uBound =0 ;
		ITimeZone *pTZ = NULL;
		
		COleSafeArray sa(vTZs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTZ);
			if (pTZ != NULL)
			{
				CString sTZid;
				sTZid.Format(L"%ld",pTZ->TimeZoneID);
				m_TZList.AddString(sTZid);
				pTZ->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_TZList.SetCurSel(0);
}

void CEditTimeZone :: GetTimeZoneDetails()
{
	//select time zone name 
		int index = m_TZList.GetCurSel();
		CString sTZName;
		m_TZList.GetLBText(index,sTZName);
		long lTimeZoneID  = _wtoi(sTZName);
		BSTR pBstrTimezoneName;
		pApplication->GetTimezoneNameByID(lTimeZoneID,&pBstrTimezoneName);
		_variant_t vTZ;
		vTZ.Clear();
		pApplication->GetTimeZoneByName(pBstrTimezoneName,&vTZ);

		if(vTZ.vt ==  VT_EMPTY)
		{
			return;
		}
		UpdateData(TRUE);
		if( vTZ.vt & VT_DISPATCH)
		{
			
			ITimeZonePtr pTZ(vTZ.pdispVal);
			m_TZName =CString(((LPWSTR)pTZ->TimeZoneName));
			m_TZDescription =CString(((LPWSTR)pTZ->TimeZoneDesc));
		}

		UpdateData(FALSE);
		if(NULL != vTZ.pdispVal)
		{
			vTZ.Clear();
		}
}

BEGIN_MESSAGE_MAP(CEditTimeZone, CDialog)
	//{{AFX_MSG_MAP(CEditTimeZone)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_TZLIST, OnSelchangeTzlist)
	ON_BN_CLICKED(ID_EDIT, OnEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditTimeZone message handlers

BOOL CEditTimeZone::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEditTimeZone::OnSelchangeAcctlist() 
{
	m_Cnt_TZName.SetWindowText(L"");
	m_Cnt_TZDescription.SetWindowText(L"");
	m_TZList.ResetContent();
	LoadTimeZones();	
}

void CEditTimeZone::OnSelchangeTzlist() 
{
	m_Cnt_TZName.SetWindowText(L"");
	m_Cnt_TZDescription.SetWindowText(L"");
	GetTimeZoneDetails();
	m_Cnt_TZName.SetFocus();
	m_Cnt_TZName.SetSel(0,-1);	
}

void CEditTimeZone::OnEdit() 
{
	BSTR bstrTZName;
	BSTR bstrTZDesc;
	BSTR bstrAcctName;
	BSTR bstrExTZID;
	long lTimeZoneID = 0;
	UpdateData(TRUE);
	//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}
	//select time zone List
		int index_TZ = m_TZList.GetCurSel();
		CString sTZName;
		if (index_TZ <0)
			bstrExTZID = SysAllocString(L"");
		else
		{
			m_TZList.GetLBText(index_TZ,sTZName);
			bstrExTZID = sTZName.AllocSysString();
			lTimeZoneID = _wtoi(sTZName);
		}
		
	BSTR pBstrTimezoneName ;

	pApplication->GetTimezoneNameByID(lTimeZoneID,&pBstrTimezoneName);
	//get time zone name & Description

	bstrTZName = m_TZName.AllocSysString();
	bstrTZDesc = m_TZDescription.AllocSysString();
	//set time zone properties
	pTZ->AccountName = bstrAcctName;
	pTZ->TimeZoneName = bstrTZName;
	pTZ->TimeZoneDesc = bstrTZDesc;
	
	long lStatus;
	pApplication->EditTimeZone(pBstrTimezoneName,bstrAcctName,pTZ,&lStatus);
		
		if (lStatus == 105)
		{
			AfxMessageBox(L"InValid Account name");
			return;
		}
		if(lStatus == 601)
		{
			AfxMessageBox(L"InValid Time Zone name");
			return;
		}
		if (lStatus == 603)
		{
			AfxMessageBox(L"Invalid Time Zone Name / Description string length");
			return;
		}
		if ( lStatus == 602)
		{
			AfxMessageBox(L"Time Zone Name Exists");
			return;
		}
		if ( lStatus == 604)
		{
			AfxMessageBox(L"System Time zone can not be edited");
			return;
		}
		if ( lStatus == 614)
		{
			AfxMessageBox(L"Given time zone does not exist");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Time zone Edit Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Time Zone Edit succeded");
			CDialog::OnOK();
		}

	UpdateData(FALSE);	
}
